systems="p101 p102 p103 p104 p105 p106 p107 p108"
p520="p520-1"
hmc="hmc1"
nim="nim"
NIM=nim

spot="spot_aix610tl01"
lpp="aix610tl01"
bosdata="bosinst_micropartition"
resolv_conf="ites_resolv"
fb_script="firstboot_ites"

. common_procedures


echo "Resetting NIM state for $systems..."
ssh -n $nim nim -o reset -F $systems

for i in $systems
do
  echo "Deallocationg all resources for $i..."
  deallocate_nim_resources $i
done

echo "Allocating resources for $systems..."
ssh -n $nim nim -o allocate -a spot=$spot\
                  -a lpp_source=$lpp\
                  -a resolv_conf=$resolv_conf\
                  -a fb_script=$fb_script\
                  -a bosinst_data=$bosdata $systems

echo "Initiating the installation for $systems"
ssh -n $nim nim -o bos_inst -a accept_licenses=yes -a no_client_boot=yes $systems

for i in $systems
do
  echo "Starting partition $i..."
  mac=`ssh -n nim lsnim -l $i | grep if1 | awk '{print $5}'`
  ssh -n $hmc lpar_netboot -t ent -m $mac -f -i -s auto -d auto $i default $p520 &
done

wait
