#!/bin/bash

HMC="hmc1"
P520="p520-1"
FILE="p520-1_dualvio.config"
VIO1="vio1"
VIO2="vio1a"
NIM="nim"
nim="nim"
FB_SCRIPT1="setup-vio1_dualvio"
FB_SCRIPT2="setup-vio1a_dualvio"
VIOSPOT="spot_vios_152"
VIOMKSYSB="mksysb_vios_152"
VIOBOSINST="bosinst_lpar_hdisk0"

. common_procedures

echo "Poweroff van ${P520} (kan 1 minuut duren)..."
ssh -n $HMC chsysstate -m $P520 -r sys -o off --immed

while [ "`ssh -n $HMC lssyscfg -r sys -m $P520 -F state`" != "Power Off" ]
do
  sleep 10
done

echo "Poweron naar standby (kan 2.5 minuut duren)..."
ssh -n $HMC chsysstate -m $P520 -r sys -o onstandby

while [ "`ssh -n $HMC lssyscfg -r sys -m $P520 -F state`" != "Standby" ]
do
  sleep 10
done

echo "Initialiseren van ${P520} (kan 1.5 minuut duren)..."
ssh -n $HMC rstprofdata -m $P520 -l 4

cat $FILE | grep -v '^#' | while true
do
  read LINE
  if [ ! -z "$LINE" ]
  then 
    echo Maken profiel voor partitie `echo $LINE | awk -F, '{print $2}'`
    ssh -n $HMC mksyscfg -r lpar -m $P520 -i \'${LINE}\'
  else
    break
  fi
done 

echo "Voorbereiden van de VIO installaties vanaf NIM (kan 2 minuten duren)..."
ssh -n $NIM nim -o reset -F $VIO1 $VIO2
deallocate_nim_resources $VIO1
deallocate_nim_resources $VIO2

ssh -n $NIM nim -o bos_inst -F -a spot=$VIOSPOT\
                            -a bosinst_data=$VIOBOSINST\
                            -a accept_licenses=yes\
                            -a source=mksysb\
                            -a mksysb=$VIOMKSYSB\
                            -a no_nim_client=yes\
			    -a no_client_boot=yes\
                            -a fb_script=$FB_SCRIPT1 $VIO1
ssh -n $NIM nim -o bos_inst -F -a spot=$VIOSPOT\
                            -a bosinst_data=$VIOBOSINST\
                            -a accept_licenses=yes\
                            -a source=mksysb\
                            -a mksysb=$VIOMKSYSB\
                            -a no_nim_client=yes\
			    -a no_client_boot=yes\
                            -a fb_script=$FB_SCRIPT2 $VIO2

echo "VIO servers opstarten..."

mac=`ssh -n $NIM lsnim -l $VIO1 | grep if1 | head -n 1 | awk '{print $5}'`
ssh -n $HMC lpar_netboot -f -t ent -m $mac -s 100 -d full $VIO1 default $P520

mac=`ssh -n $NIM lsnim -l $VIO2 | grep if1 | head -n 1 | awk '{print $5}'`
ssh -n $HMC lpar_netboot -f -t ent -m $mac -s 100 -d full $VIO2 default $P520

echo LED uitzetten
ssh -n $HMC chled -r sa -t phys -m $P520 -o off
