cli=/usr/ios/cli/ioscli

myhostname=vio1.educ.ibm.nl
myip=10.24.23.100
netmask=255.255.255.0
gateway=10.24.23.254
nsrvaddr=10.24.0.4
nsrvdomain=educ.ibm.nl
virtualethadapter1=ent2
virtualethadapter2=ent3
heartbeatethadapter1=ent4
heartbeatethadapter2=ent5
realethadapter1=ent0
realethadapter2=ent1
seaethinterface1=en6
seaethinterface2=en7
vlanid1=1
vlanid2=2
heartbeat1=101
heartbeat2=102
viosystems="01 02 03 04 05 06 07 08"

# Accept the license
echo Accepting the license...
$cli license -accept

# List of adapters
echo List of all adapters:
lsdev -Cc adapter | grep ^en
echo

# Configure the sea adapters
echo Configuring real $realethadapter1 and virtual $virtualethadapter1 as SEA adapter $seaethinterface1...
$cli mkvdev -sea $realethadapter1 -vadapter $virtualethadapter1 -default $virtualethadapter1 -defaultid $vlanid1 -attr ha_mode=auto ctl_chan=$heartbeatethadapter1 netaddr=$gateway

echo Configuring real $realethadapter2 and virtual $virtualethadapter2 as SEA adapter $seaethinterface2...
$cli mkvdev -sea $realethadapter2 -vadapter $virtualethadapter2 -default $virtualethadapter2 -defaultid $vlanid2 -attr ha_mode=auto ctl_chan=$heartbeatethadapter2 netaddr=$gateway

# Configure networking on sea adapter 1 (adapter 2 is not configured)
echo Configuring sea interface $seainterface1 for tcpip...
$cli mktcpip -hostname $myhostname -interface $seaethinterface1 -inetaddr $myip -netmask $netmask -gateway $gateway -nsrvaddr $nsrvaddr -nsrvdomain $nsrvdomain

# Attach SAN disks to SCSI server adapters
echo Attaching SAN disks to SCSI server adapters

numlocaldisks=`lsdev -Cc disk | grep -v "Disk Array Device" | wc -l`
sandisks=`lsdev -Cc disk | grep "Disk Array Device" | awk '{print $1}'`
echo SAN disks are $sandisks

for i in $sandisks
do
  dd if=/dev/zero of=/dev/$i bs=1M count=10
  $cli chdev -dev $i -attr reserve_policy=no_reserve
done

for i in $viosystems
do
  $cli mkvdev -vdev hdisk$(( ${i} + $numlocaldisks - 1 )) -vadapter vhost$(( ${i} - 1 ))
done

echo Setting padmin password to abc1234...
grep -v -p padmin /etc/security/passwd > /tmp/passwd
cat << END >> /tmp/passwd
padmin:
        password = ECu9Pjj38c3kE
        flags =
        lastupdate = 1215017269
END
rm -f /etc/security/passwd
mv /tmp/passwd /etc/security/passwd

echo All done.
